/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.DexMethodHeadParser;
import hu.uw.pallergabor.dedexer.DexParser;
import hu.uw.pallergabor.dedexer.DexTypeIdsBlock;
import java.io.IOException;

public class DexTryCatchBlockParser
extends DexParser {
    private DexMethodHeadParser dexMethodHeadParser;
    private DexTypeIdsBlock dexTypeIdsBlock;
    private TryHolder[] triesList;
    private CatchHolder[] catchList;

    @Override
    public void parse() throws IOException {
        this.file.seek(this.dexMethodHeadParser.getNextBlockOffset());
        int triesNumber = this.dexMethodHeadParser.getTriesSize();
        this.triesList = new TryHolder[triesNumber];
        int i = 0;
        while (i < triesNumber) {
            long tryBase = this.read32Bit();
            int trySpan = this.read16Bit();
            TryHolder tryHolder = new TryHolder();
            tryHolder.startOffset = this.dexMethodHeadParser.getInstructionBase() + tryBase * 2L;
            tryHolder.endOffset = tryHolder.startOffset + (long)(trySpan * 2);
            this.dump("start offset: 0x" + Long.toHexString(tryHolder.startOffset) + "; end offset: 0x" + Long.toHexString(tryHolder.endOffset));
            tryHolder.catchOffset = this.read16Bit();
            tryHolder.catchIndex = -1;
            this.dump("catch offset: " + tryHolder.catchOffset);
            this.triesList[i] = tryHolder;
            ++i;
        }
        long catchTableBase = this.file.getFilePointer();
        int handlerSize = (int)this.readVLN();
        this.catchList = new CatchHolder[handlerSize];
        int i2 = 0;
        while (i2 < handlerSize) {
            int encodedItems;
            int catchItemOffset = (int)(this.file.getFilePointer() - catchTableBase);
            int realSize = encodedItems = (int)this.readSignedVLN();
            boolean anyHandlerPresent = false;
            if (encodedItems == 0) {
                realSize = 1;
                anyHandlerPresent = true;
            } else if (encodedItems < 0) {
                encodedItems = -encodedItems;
                realSize = encodedItems + 1;
                anyHandlerPresent = true;
            }
            CatchHolder catchHolder = new CatchHolder();
            catchHolder.catchOffset = catchItemOffset;
            this.dump("Handler #" + i2 + "; offset: " + catchItemOffset);
            CatchItemHolder[] catchItemList = new CatchItemHolder[realSize];
            int n = 0;
            while (n < encodedItems) {
                CatchItemHolder catchItemHolder = new CatchItemHolder();
                catchItemHolder.typeidx = (int)this.readVLN();
                catchItemHolder.offset = this.dexMethodHeadParser.getInstructionBase() + 2L * this.readVLN();
                catchItemList[n] = catchItemHolder;
                this.dump("Exception: " + this.dexTypeIdsBlock.getClassName(catchItemHolder.typeidx) + "; offset: " + Long.toHexString(catchItemHolder.offset));
                ++n;
            }
            if (anyHandlerPresent) {
                CatchItemHolder catchItemHolder = new CatchItemHolder();
                catchItemHolder.typeidx = -1;
                catchItemHolder.offset = this.dexMethodHeadParser.getInstructionBase() + 2L * this.readVLN();
                catchItemList[realSize - 1] = catchItemHolder;
                this.dump("Exception: <any>; offset: " + Long.toHexString(catchItemHolder.offset));
            }
            catchHolder.items = catchItemList;
            n = 0;
            while (n < triesNumber) {
                if (this.triesList[n].catchOffset == catchItemOffset) {
                    this.triesList[n].catchIndex = i2;
                }
                ++n;
            }
            this.catchList[i2] = catchHolder;
            ++i2;
        }
    }

    public void setDexMethodHeadParser(DexMethodHeadParser dexMethodHeadParser) {
        this.dexMethodHeadParser = dexMethodHeadParser;
    }

    public void setDexTypeIdsBlock(DexTypeIdsBlock dexTypeIdsBlock) {
        this.dexTypeIdsBlock = dexTypeIdsBlock;
    }

    public int getTriesSize() {
        return this.triesList.length;
    }

    public long getTryStartOffset(int idx) {
        return this.triesList[idx].startOffset;
    }

    public long getTryEndOffset(int idx) {
        return this.triesList[idx].endOffset;
    }

    public int getTryHandlersSize(int idx) {
        int holderIdx = this.triesList[idx].catchIndex;
        if (holderIdx < 0) {
            return 0;
        }
        CatchHolder catchHolder = this.catchList[holderIdx];
        return catchHolder.items.length;
    }

    public String getTryHandlerType(int tryidx, int handleridx) {
        int holderIdx = this.triesList[tryidx].catchIndex;
        if (holderIdx < 0) {
            return null;
        }
        CatchHolder catchHolder = this.catchList[holderIdx];
        CatchItemHolder catchItemHolder = catchHolder.items[handleridx];
        int typeidx = catchItemHolder.typeidx;
        String typeName = typeidx < 0 ? "java/lang/Exception" : this.dexTypeIdsBlock.getClassName(typeidx);
        return typeName;
    }

    public long getTryHandlerOffset(int tryidx, int handleridx) {
        int holderIdx = this.triesList[tryidx].catchIndex;
        if (holderIdx < 0) {
            return 0L;
        }
        CatchHolder catchHolder = this.catchList[holderIdx];
        CatchItemHolder catchItemHolder = catchHolder.items[handleridx];
        return catchItemHolder.offset;
    }

    class CatchHolder {
        CatchItemHolder[] items;
        int catchOffset;

        CatchHolder() {
        }
    }

    class CatchItemHolder {
        int typeidx;
        long offset;

        CatchItemHolder() {
        }
    }

    class TryHolder {
        long startOffset;
        long endOffset;
        int catchOffset;
        int catchIndex;

        TryHolder() {
        }
    }
}

