/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.AnnotationHolder;
import hu.uw.pallergabor.dedexer.DexAnnotationParser;
import hu.uw.pallergabor.dedexer.DexFieldIdsBlock;
import hu.uw.pallergabor.dedexer.DexMethodIdsBlock;
import hu.uw.pallergabor.dedexer.DexParser;
import hu.uw.pallergabor.dedexer.DexStringIdsBlock;
import hu.uw.pallergabor.dedexer.DexTypeIdsBlock;
import hu.uw.pallergabor.dedexer.StaticAnnotation;
import hu.uw.pallergabor.dedexer.StaticArray;
import hu.uw.pallergabor.dedexer.StaticCharacter;
import hu.uw.pallergabor.dedexer.StaticString;
import java.io.IOException;

public class DexEncodedArrayParser
extends DexParser {
    public static final int VALUE_BYTE = 0;
    public static final int VALUE_SHORT = 2;
    public static final int VALUE_CHAR = 3;
    public static final int VALUE_INT = 4;
    public static final int VALUE_LONG = 6;
    public static final int VALUE_UNKNOWN1 = 15;
    public static final int VALUE_FLOAT = 16;
    public static final int VALUE_DOUBLE = 17;
    public static final int VALUE_STRING = 23;
    public static final int VALUE_TYPE = 24;
    public static final int VALUE_FIELD = 25;
    public static final int VALUE_METHOD = 26;
    public static final int VALUE_ENUM = 27;
    public static final int VALUE_ARRAY = 28;
    public static final int VALUE_ANNOTATION = 29;
    public static final int VALUE_NULL = 30;
    public static final int VALUE_BOOLEAN = 31;
    private Object[] elements;
    private DexStringIdsBlock dexStringIdsBlock = null;
    private DexTypeIdsBlock dexTypeIdsBlock = null;
    private DexFieldIdsBlock dexFieldIdsBlock = null;
    private DexMethodIdsBlock dexMethodIdsBlock = null;

    @Override
    public void parse() throws IOException {
        int arrayItemNum = (int)this.readVLN();
        this.dump("array item count: " + arrayItemNum);
        this.elements = new Object[arrayItemNum];
        int i = 0;
        while (i < arrayItemNum) {
            this.elements[i] = this.readElement();
            this.dump("Array element[" + i + "]: " + this.elements[i]);
            ++i;
        }
    }

    public int getArraySize() {
        return this.elements.length;
    }

    public Object getArrayElement(int idx) {
        return this.elements[idx];
    }

    public Object readElement() throws IOException {
        int b = this.read8Bit();
        int valueArg = (b & 0xE0) >> 5;
        int valueType = b & 0x1F;
        Object returnObject = null;
        switch (valueType) {
            case 0: {
                int bv = this.readSigned8Bit();
                returnObject = new Byte((byte)bv);
                break;
            }
            case 2: {
                long sv = this.readVLNWithLength(valueArg + 1, true);
                returnObject = new Short((short)sv);
                break;
            }
            case 3: {
                long cv = this.readVLNWithLength(valueArg + 1, false);
                returnObject = new StaticCharacter((char)cv);
                break;
            }
            case 4: {
                long lv = this.readVLNWithLength(valueArg + 1, true);
                int iv = (int)lv;
                returnObject = new Integer(iv);
                break;
            }
            case 6: {
                long lv = this.readVLNWithLength(valueArg + 1, true);
                returnObject = new Long(lv);
                break;
            }
            case 16: {
                long lv = this.readFloatingPointVLNWithLength(valueArg + 1) >> 32;
                returnObject = new Float(Float.intBitsToFloat((int)lv));
                break;
            }
            case 17: {
                long lv = this.readFloatingPointVLNWithLength(valueArg + 1);
                returnObject = new Double(Double.longBitsToDouble(lv));
                break;
            }
            case 23: {
                long si = this.readVLNWithLength(valueArg + 1, false);
                String stringValue = this.dexStringIdsBlock.getString((int)si);
                returnObject = new StaticString(stringValue);
                break;
            }
            case 24: {
                long ti = this.readVLNWithLength(valueArg + 1, false);
                String typeValue = this.dexTypeIdsBlock.getType((int)ti);
                returnObject = typeValue;
                break;
            }
            case 25: {
                long fi = this.readVLNWithLength(valueArg + 1, false);
                String fieldValue = this.dexFieldIdsBlock.getField((int)fi);
                returnObject = fieldValue;
                break;
            }
            case 26: {
                long mi = this.readVLNWithLength(valueArg + 1, false);
                String methodName = this.dexMethodIdsBlock.getMethod((int)mi);
                String proto = this.dexMethodIdsBlock.getProto((int)mi);
                String methodValue = DexMethodIdsBlock.combineMethodNameAndProto(methodName, proto);
                returnObject = methodValue;
                break;
            }
            case 27: {
                long fi = this.readVLNWithLength(valueArg + 1, false);
                String enumValue = this.dexFieldIdsBlock.getFieldName((int)fi);
                returnObject = enumValue;
                break;
            }
            case 28: {
                DexEncodedArrayParser arrayParser = new DexEncodedArrayParser();
                arrayParser.setRandomAccessFile(this.file);
                arrayParser.setDumpFile(this.dump);
                arrayParser.setDexStringIdsBlock(this.dexStringIdsBlock);
                arrayParser.setDexTypeIdsBlock(this.dexTypeIdsBlock);
                arrayParser.setDexFieldIdsBlock(this.dexFieldIdsBlock);
                arrayParser.setDexMethodIdsBlock(this.dexMethodIdsBlock);
                arrayParser.parse();
                int arraySize = arrayParser.getArraySize();
                StaticArray array = new StaticArray(arraySize);
                int i = 0;
                while (i < arraySize) {
                    array.set(i, arrayParser.getArrayElement(i));
                    ++i;
                }
                returnObject = array;
                break;
            }
            case 29: {
                DexAnnotationParser annotationParser = new DexAnnotationParser();
                annotationParser.setRandomAccessFile(this.file);
                annotationParser.setDumpFile(this.dump);
                annotationParser.setDexTypeIdsBlock(this.dexTypeIdsBlock);
                annotationParser.setDexStringIdsBlock(this.dexStringIdsBlock);
                annotationParser.setDexFieldIdsBlock(this.dexFieldIdsBlock);
                annotationParser.setDexMethodIdsBlock(this.dexMethodIdsBlock);
                AnnotationHolder holder = new AnnotationHolder();
                holder.newAnnotation();
                annotationParser.readEncodedAnnotation(holder, "sub-annotation");
                StaticAnnotation s = new StaticAnnotation(holder);
                returnObject = s;
                break;
            }
            case 30: {
                returnObject = "null";
                break;
            }
            case 31: {
                returnObject = new Boolean(valueArg != 0);
                break;
            }
            default: {
                throw new IOException("Unhandled array type (0x" + this.dumpByte(valueType) + ") at 0x" + Long.toHexString(this.getFilePosition() - 1L));
            }
        }
        return returnObject;
    }

    public static String getTypeString(Object o) {
        Object obj = o;
        String typeString = "";
        if (obj instanceof StaticArray) {
            typeString = String.valueOf(typeString) + "[";
            StaticArray array = (StaticArray)obj;
            Object object = obj = array.length() == 0 ? null : array.get(0);
        }
        if (obj != null) {
            typeString = obj instanceof Boolean ? String.valueOf(typeString) + "Z" : (obj instanceof Byte ? String.valueOf(typeString) + "B" : (obj instanceof Short ? String.valueOf(typeString) + "S" : (obj instanceof StaticCharacter ? String.valueOf(typeString) + "C" : (obj instanceof Integer ? String.valueOf(typeString) + "I" : (obj instanceof Long ? String.valueOf(typeString) + "J" : (obj instanceof Float ? String.valueOf(typeString) + "F" : (obj instanceof Double ? String.valueOf(typeString) + "D" : (obj instanceof StaticString ? String.valueOf(typeString) + "Ljava/lang/String;" : (obj instanceof String ? String.valueOf(typeString) + "<string>" : (obj instanceof StaticAnnotation ? String.valueOf(typeString) + "annotation" : String.valueOf(typeString) + "<unknown type>"))))))))));
        }
        return typeString;
    }

    public void setDexStringIdsBlock(DexStringIdsBlock dexStringIdsBlock) {
        this.dexStringIdsBlock = dexStringIdsBlock;
    }

    public void setDexTypeIdsBlock(DexTypeIdsBlock dexTypeIdsBlock) {
        this.dexTypeIdsBlock = dexTypeIdsBlock;
    }

    public void setDexFieldIdsBlock(DexFieldIdsBlock dexFieldIdsBlock) {
        this.dexFieldIdsBlock = dexFieldIdsBlock;
    }

    public void setDexMethodIdsBlock(DexMethodIdsBlock dexMethodIdsBlock) {
        this.dexMethodIdsBlock = dexMethodIdsBlock;
    }
}

