/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.CodeGenerator;
import hu.uw.pallergabor.dedexer.DedexerTask;
import hu.uw.pallergabor.dedexer.DexInstructionParser;
import java.io.IOException;

public class FillArrayTask
extends DedexerTask {
    private String typeString;

    public FillArrayTask(DexInstructionParser instrParser, long base, long offset) {
        super(instrParser, base, offset);
    }

    @Override
    public boolean equals(DedexerTask o) {
        if (!(o instanceof FillArrayTask)) {
            return false;
        }
        return super.equals(o);
    }

    public void setType(String typeString) {
        this.typeString = typeString;
    }

    @Override
    public void doTask(boolean isSecondPass) throws IOException {
        this.instrParser.placeTask(this.offset, this);
    }

    @Override
    public void renderTask(long position) throws IOException {
        int tableType = this.instrParser.read16Bit();
        if (tableType != 768) {
            throw new IOException("Invalid array-data table type (0x" + Integer.toHexString(tableType) + ") at offset 0x" + Long.toHexString(this.instrParser.getFilePosition() - 2L));
        }
        int bytesPerElement = this.instrParser.read16Bit();
        long numberOfElements = this.instrParser.read32Bit();
        CodeGenerator cg = this.instrParser.getCodeGenerator();
        String arrayDataLabel = DexInstructionParser.labelForAddress(this.offset);
        cg.openDataArray(arrayDataLabel);
        long l = 0L;
        while (l < numberOfElements) {
            StringBuilder element = new StringBuilder();
            long elementValue = 0L;
            boolean byteOffset = false;
            int i = 0;
            while (i < bytesPerElement) {
                if (i > 0) {
                    element.append(", ");
                }
                int b = this.instrParser.read8Bit();
                element.append("0x");
                element.append(this.instrParser.dumpByte(b));
                ++i;
            }
            cg.writeElement(l, new String(element));
            ++l;
        }
        cg.closeDataArray(arrayDataLabel);
    }

    @Override
    public boolean getParseFlag(long position) {
        return true;
    }
}

