<?php
header('Content-Type:text/html;charset=utf-8');
define('EAR_ROOT', __DIR__);
define("EAR_SCRIPT", trim($_SERVER["SCRIPT_NAME"], "/"));
define("DS", DIRECTORY_SEPARATOR);
define('EAR_DATA', EAR_ROOT.DS."data");
define("EAR_PATH", rtrim(dirname($_SERVER["SCRIPT_NAME"]), "/")."/");

require_once(EAR_ROOT.DS.'vendor'.DS.'autoload.php');
foreach(glob(EAR_ROOT.DS.'source'.DS.'system'.DS.'*.php') as $sys_file){
    require_once($sys_file);
}

if(!file_exists(EAR_ROOT.DS.'earcms_config_sample.php')){
    echo html_message("安装错误", "文件缺失：./earcms_config_sample.php");
    exit;
}
if(version_compare(PHP_VERSION,'5.5.0','<')){ 
    echo html_message("安装错误", '请使用 PHP 5.5 以上版本');
    exit;
}
require_once(EAR_ROOT.DS.'earcms_config_sample.php');

$step = isset($_GET["step"])?intval($_GET["step"]):(file_exists(EAR_ROOT.DS.'data'.DS.'install.lock')?4:1);

$dir = EAR_ROOT.DS.'source'.DS.'install'.DS;
require_once($dir.'header.inc.php');

switch($step){
    case 1:
        require_once($dir.'env.php');
        break;
    case 2:
        require_once($dir.'config.php');
        break;
    case 3:
        require_once($dir.'admin.php');
        break;
    case 4:
        require_once($dir.'complete.php');
        break;
    default:
        die("Access Denied");
}
require_once(EAR_ROOT.DS.'source'.DS.'install'.DS.'bottom.inc.php');
?>
