<?php
if (!defined('EAR_ROOT')) {
	die('Access denied');
}
?>
<!doctype html>
<html lang="cn">

  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?php echo isset($title)?esc_html($title):esc_html(EAR_NAME." | ".EAR_DESCRIPTION);?></title>
    <link rel="shortcut icon" href="/favicon.ico" />
    <link rel="stylesheet" href="<?php echo EAR_PATH;?>static/index/css/index.min.css">
    <link rel="stylesheet" href="<?php echo EAR_PATH;?>static/index/font/iconfont.css?v=1.0">
    <link rel="stylesheet" href="//cdn.jsdelivr.net/npm/bootstrap-icons@1.10.3/font/bootstrap-icons.css">
    <script src="//cdn.jsdelivr.net/npm/showdown@2.1.0/dist/showdown.min.js" type="text/javascript"></script>
    <style>
        .hidden {
            display: none !important;
        }
        input[type="number"]{
            width: 100%;
            float: left;
            padding: 0 15px;
            height: 51px;
            line-height: 48px;
            border: 1px solid #eee;
            color: #59597e;
            transition: all .5s ease-in-out;
            transition: all .5s ease-in-out;
            -moz-transition: all .5s ease-in-out;
            -ms-transition: all .5s ease-in-out;
            -o-transition: all .5s ease-in-out;
            -webkit-transition: all .5s ease-in-out;
            -webkit-border-radius: 6px;
            -moz-border-radius: 6px;
            border-radius: 6px;
        }
        .card{
            margin: 1em 0;
        }
    </style>
    <script src="<?php echo EAR_PATH;?>static/index/js/index.min.js" type="text/javascript"></script>
    <script type="text/javascript">
    $(document).ready(function() {
        $(".nav-item a.disabled").click(function(){return false;});
    });
    </script>
  <body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark" style="background:#0d1e67;">
      <a class="navbar-brand" href="#">EarCMS</a>
      <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="collapse navbar-collapse" id="navbarSupportedContent">
        <ul class="navbar-nav mr-auto">
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-expanded="false">
              应用管理
            </a>
            <div class="dropdown-menu">
              <a class="dropdown-item" href="<?php echo EAR_PATH.EAR_SCRIPT;?>/apps">应用列表</a>
              <div class="dropdown-divider"></div>
              <a class="dropdown-item disabled" href="<?php echo EAR_PATH.EAR_SCRIPT;?>/packs">封装记录</a>
              <a class="dropdown-item disabled" href="<?php echo EAR_PATH.EAR_SCRIPT;?>/signs">签名记录</a>
              <a class="dropdown-item disabled" href="<?php echo EAR_PATH.EAR_SCRIPT;?>/downloads">下载记录</a>
            </div>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="<?php echo EAR_PATH.EAR_SCRIPT;?>/users">用户管理</a>
          </li>
          <li class="nav-item">
            <a class="nav-link disabled" href="<?php echo EAR_PATH.EAR_SCRIPT;?>/orders">订单管理</a>
          </li>
          <li class="nav-item">
            <a class="nav-link disabled" href="<?php echo EAR_PATH.EAR_SCRIPT;?>/certs">证书管理</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="<?php echo EAR_PATH.EAR_SCRIPT;?>/config">系统配置</a>
          </li>
        </ul>
        <div class="dropdown">
          <a class="btn btn-dark dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-expanded="false">
            <?php echo esc_html($_SESSION["admin"]["email"]);?>
          </a>

          <div class="dropdown-menu">
            <a class="dropdown-item" href="<?php echo EAR_PATH.EAR_SCRIPT;?>/passwd">修改密码</a>
            <a class="dropdown-item" href="<?php echo EAR_PATH.EAR_SCRIPT;?>/logout">退出</a>
          </div>
        </div>


      </div>
    </nav>

