<?php
if (!defined('EAR_ROOT')) {
	die('Access denied');
}
class ShortURL{
    public $file;
    
    public function __construct(){
        $this->file = EAR_DATA.DS."shorturl.php";
    }
    
    public function getUrls(){
        if(!file_exists($this->file))
            return false;
        $str = file_get_contents($this->file);
        $urls = EarData::decode($str);
        return $urls;
    }
    
    public function get($shorturl){
        if(!is_alphanum_str($shorturl))
            return false;
        $urls = $this->getUrls();
        return isset($urls[$shorturl])?$urls[$shorturl]:false;
    }
    
    public function unset($shorturl){
        if($shorturl == false)
            return true;
        if(!is_alphanum_str($shorturl))
            return false;
        $urls = $this->getUrls();
        if(isset($urls[$shorturl])){
            unset($urls[$shorturl]);
            $str = EarData::encode($urls);
            return file_put_contents($this->file, $str);
        }
        return true;
    }
    
    public function set($shorturl, $uuid){
        if(!is_safe_str($uuid) || !is_alphanum_str($shorturl))
            return false;
        $urls = $this->getUrls();
        $urls[$shorturl] = $uuid;
        $str = EarData::encode($urls);
        return file_put_contents($this->file, $str);
    }
    
}
