<?php
if (!defined('EAR_ROOT')) {
	die('Access denied');
}
class User{
    public $dir;
    public $role = "user";
    
    public function __construct(){
        $this->dir = EAR_DATA.DS."users";
        $this->init();
    }
    
    public function init(){
        if(!file_exists($this->dir)){
            mkdir($this->dir, 0777, true);
        }
        if(!file_exists($this->dir.DS."index.php")){
            file_put_contents($this->dir.DS."index.php", "");
        }
    }
    
    public function getUsers($sort=0, $offset=0, $length=100){
        $users = array();
        $files = glob($this->dir.DS."*_*.php");
        if($sort == 1){
            $files = array_reverse($files);
        }
        foreach(array_slice($files, $offset, $length) as $file){
            $str = file_get_contents($file);
            $users[$file] = EarData::decode($str);
        }
        return $users;
    }
    
    public function isExists($email){
        $file = $this->getFilepath($email);
        return file_exists($file);
    }
    
    public function getFilepath($email){
        $email = strtolower(trim($email));
        $md5 = md5($email);
        $files = glob($this->dir.DS."*_{$md5}.php");
        if($files == false){
            return $this->dir.DS.time()."_".uuid()."_".$md5.".php";
        }else{
            return $files[0];
        }
    }
    
    public function getUser($email){
        $file = $this->getFilepath($email);
        if(!file_exists($file)){
            return false;
        }
        $str = file_get_contents($file);
        return EarData::decode($str);
    }
    
    public function login($email, $password){
        $user = $this->getUser($email);
        if($user == false){
            return false;
        }
        $hash = isset($user["password"])?$user["password"]:false;
        $salt = isset($user["salt"])?$user["salt"]:false;
        $status = isset($user["status"])?$user["status"]:false;
        if($hash == false || $salt == false || $hash !== md5($password.$salt) || $status == false){
            return false;
        }
        $this->update($email, "lasttime", time());
        $this->update($email, "lastip", get_ip());
        $_SESSION[$this->role] = $user;
        return true;
    }
    
    public function add($email, $password){
        $user = $this->getUser($email);
        if($user != false){
            return false;
        }
        $salt = get_salt(8);
        $hash = md5($password.$salt);
        $user = array(
            "salt"  => $salt,
            "password"  => $hash,
            "status"    => true,
            "email" => $email,
            "times2down" => 90000,
            "times2sign" => 0,
            "times2pack" => 0,
            "name"  => "",
            "idcard"    => "",
            "realstatus" => false,
            "addtime"   => time(),
            "lasttime"  => null,
            "lastip"    => get_ip(),
        );
        $file = $this->getFilepath($email);
        $str = EarData::encode($user);
        return file_put_contents($file, $str);
    }
    
    public function update($email, $key, $value){
        $user = $this->getUser($email);
        if($user == false){
            return false;
        }
        $user[$key] = $value;
        $file = $this->getFilepath($email);
        $str = EarData::encode($user);
        return file_put_contents($file, $str);
    }
    
    public function logout(){
        unset($_SESSION);
        session_unset();
        session_destroy();
    }
}
