<?php
if (!defined('EAR_ROOT')) {
	die('Access denied');
}
if(!earis_login("admin")){
    header("Location: ".EAR_PATH.EAR_SCRIPT."/login");
    exit;
}

$sort = isset($_GET["sort"])?intval($_GET["sort"]):1;
$offset = isset($_GET["offset"])?intval($_GET["offset"]):0;
$length = isset($_GET["length"])?intval($_GET["length"]):20;
$usrObj = new User();
$users = $usrObj->getUsers($sort, $offset, $length);

$title = "用户列表 | ".EAR_NAME;
require_once("header.inc.php");
?>
<div style="padding:1em;">
<?php if($users == false){ ?>
      <div class="alert alert-light" role="alert" style="margin:2em 0;text-align:center;">无内容</div>
      <?php }else{ ?>
      <table class="table table-hover">
        <thead>
          <tr>
            <th scope="col">#</th>
            <th scope="col">邮箱</th>
            <th scope="col">状态</th>
            <th scope="col">实名状态</th>
            <th scope="col">剩余下载次数</th>
            <th scope="col">剩余签名次数</th>
            <th scope="col">剩余打包次数</th>
            <th scope="col">最后登录地址</th>
            <th scope="col">最后登录时间</th>
            <th scope="col">添加时间</th>
            <th scope="col">操作</th>
          </tr>
        </thead>
        <tbody>
          <?php 
        $id = $offset;
        foreach($users as $path => $user){
            $realstatus = boolval(@$user["realstatus"]);
            $realbadge = '<span class="badge badge-light">未实名</span>';
            if(@$user["idcard"] != false && $realstatus == false){
                $realbadge = '<span class="badge badge-warning">待审核</span>';
            }elseif($realstatus == true){
                $realbadge = '<span class="badge badge-success">已实名</span>';
            }
            echo '<tr>
            <td>'.(++$id).'</td>
            <td class="align-middle">'.esc_html($user["email"]).'</td>
            <td>'.(@$user["status"]==true?'<span class="badge badge-success">已启用</span>':'<span class="badge badge-danger">已禁用</span>').'</td>
            <td class="align-middle">'.$realbadge.'</td>
            <td class="align-middle">'.intval(@$user["times2down"]).'</td>
            <td class="align-middle">'.intval(@$user["times2sign"]).'</td>
            <td class="align-middle">'.intval(@$user["times2pack"]).'</td>
            <td class="align-middle">'.esc_html(@$user["lastip"]).'</td>
            <td class="align-middle">'.esc_html(date("Y-m-d H:i:s", @$user["lasttime"])).'</td>
            <td class="align-middle">'.esc_html(date("Y-m-d H:i:s", @$user["addtime"])).'</td>
            <td class="align-middle">
              <a href="'.esc_html(EAR_PATH.EAR_SCRIPT."/user?email=".$user["email"]).'" class="btn btn-light btn-sm" title="编辑">编辑</a>
              '.(@$user["status"]==true?'<a href="'.esc_html(EAR_PATH.EAR_SCRIPT."/lockuser?email=".$user["email"]).'" class="btn btn-light btn-sm" title="禁用">禁用</a>':'<a href="'.esc_html(EAR_PATH.EAR_SCRIPT."/unlockuser?email=".$user["email"]).'" class="btn btn-light btn-sm" title="启用">启用</a>').'
            </td>
          </tr>';
        }
        ?>
        </tbody>
      </table>

      <nav aria-label="Page navigation">
        <ul class="pagination">
          <li class="page-item <?php echo ($offset)?"":"disabled";?>"><a class="page-link" href="<?php echo ($offset)?EAR_PATH.EAR_SCRIPT."/users?offset=".($offset-$length)."&length={$length}":"#";?>">上一页</a></li>
          <li class="page-item <?php echo (count($users)<$length)?"disabled":"";?>"><a class="page-link" href="<?php echo ($users)?EAR_PATH.EAR_SCRIPT."/users?offset=".($offset+$length)."&length={$length}":"#";?>">下一页</a></li>
        </ul>
      </nav>

      <?php }?>
</div>
<?php require_once("bottom.inc.php");?>

